#include <mqx.h>
#include <bsp.h>

#include <ltc1859spi.h>

#include <logging.h>


//>>>>>>>>>>>>>>>>>>>>>>>>
//ltc1859spi.h
//ltc1859spi.c
//>>>>>>>>>>
//This file contains the send/receive functions for the LTC 1859 ADC
//The header file lists all the configuration options that can be passed in.
//






uint_32 send_receive_LTC1859 (uint_8 channel, uint_8 span, uint_8 sleep, FILE_PTR spifd)
{
   uint_32 param, output = 0x0000, result = 0x00;
   SPI_READ_WRITE_STRUCT  rw;
   uint_32 msw_msb; // Most significant word containing most significant byte
   uint_32 msw_lsb; // Most significant word containing least significant byte
   uint_32 lsw_msb; // Least significant word containing most significant byte
   uint_32 lsw_lsb; // Least significant word containing least significant byte   


   //Set up the CHANNEL field, add mask (shift up)
   param = (channel | span | sleep);
#if defined BSP_TWR_K60D100M 
   // Do nothing to reverse byte ordering for Kinetis due to differences in endianness
#else   
   param = param << 24;
#endif

   
   //The packets are 16 bits long
   rw.BUFFER_LENGTH = 2;
   rw.WRITE_BUFFER = (char*)&param;  //New compiler complains
   rw.READ_BUFFER = (char*)&output;
   //printf ("READ WRITE ... ");
   result = ioctl (spifd, IO_IOCTL_SPI_READ_WRITE, &rw);
#if defined BSP_TWR_K60D100M
// Re-order bytes when using Kinetis so that it displays correctly      
   msw_msb = (output & 0x000000ff) << 24;
   msw_lsb = (output & 0x0000ff00) << 8;
   lsw_msb = (output & 0x00ff0000) >> 8;
   lsw_lsb = (output & 0xff000000) >> 24;
   output = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);

   msw_msb = (param & 0x000000ff) << 24;
   msw_lsb = (param & 0x0000ff00) << 8;
   lsw_msb = (param & 0x00ff0000) >> 8;
   lsw_lsb = (param & 0xff000000) >> 24;   
   param = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);   
#endif   
   if (SPI_OK == result) 
   {
      //printf ("OK, sent: 0x%08x, received: 0x%08x or %d\n", param, output, output);
   } else {
      printf ("ERROR 0x%08x \n", result);
   }
   //fflush (spifd);
   
   return output;
}